<?php
/**
 * Classe pour gérer le frontend
 */

if (!defined('ABSPATH')) {
    exit;
}

class Leonix_Public {
    
    /**
     * Constructeur
     */
    public function __construct() {
        // Charger le widget uniquement si activé
        if (get_option('leonix_widget_enabled', true)) {
            add_action('wp_footer', array($this, 'load_widget'));
        }
    }
    
    /**
     * Charger le widget dans le footer
     */
    public function load_widget() {
        $agent_id = get_option('leonix_agent_id', '');
        $api_url = get_option('leonix_api_url', 'https://app.leonix.ai/api');
        $profile_image = get_option('leonix_profile_image', '');
        $widget_position = get_option('leonix_widget_position', 'right');
        
        // Ne pas charger si l'Agent ID n'est pas configuré
        if (empty($agent_id)) {
            return;
        }
        
        // URL du widget via l'API (pour contourner les problèmes CORS et ngrok)
        // Utiliser /api/widgets/script au lieu de /widgets/leonix-widget.js directement
        $widget_url = $api_url . '/widgets/script';
        
        // Debug: Ajouter un commentaire HTML pour vérifier que le plugin charge bien
        echo "\n<!-- Leonix AI Widget - Agent ID: " . esc_html($agent_id) . " -->\n";
        
        ?>
        <script>
        // Configuration du widget Leonix AI (doit être défini AVANT le chargement du script widget)
        window.leonixWidgetConfig = {
            agentId: '<?php echo esc_js($agent_id); ?>',
            apiUrl: '<?php echo esc_url($api_url); ?>',
            buttonText: '<?php echo esc_js(__('Discuter avec Leonix AI', 'leonix-ai-widget')); ?>',
            debug: false<?php if (!empty($profile_image)): ?>,
            profileImage: '<?php echo esc_js($profile_image); ?>'<?php endif; ?><?php if ($widget_position === 'left'): ?>,
            position: 'left'<?php endif; ?>
        };
        
        // Charger le script via fetch pour contourner la page d'avertissement ngrok
        // Cette méthode permet d'ajouter l'en-tête ngrok-skip-browser-warning
        (function() {
            var widgetUrl = '<?php echo esc_url($widget_url); ?>';
            
            fetch(widgetUrl, {
                headers: {
                    'ngrok-skip-browser-warning': 'true'
                }
            })
            .then(function(response) {
                if (!response.ok) {
                    throw new Error('HTTP ' + response.status);
                }
                return response.text();
            })
            .then(function(scriptContent) {
                // Créer un script et évaluer le contenu
                var script = document.createElement('script');
                script.textContent = scriptContent;
                document.head.appendChild(script);
            })
            .catch(function(error) {
                // Fallback: essayer de charger directement (pour les cas où ngrok n'est pas utilisé)
                var script = document.createElement('script');
                script.src = widgetUrl;
                document.head.appendChild(script);
            });
        })();
        </script>
        <?php
    }
}

