<?php
/**
 * Plugin Name: Leonix AI Widget
 * Plugin URI: https://leonix.ai
 * Description: Intégrez un agent IA vocal sur votre site WordPress pour permettre à vos visiteurs de discuter avec votre assistant IA.
 * Version: 1.0.0
 * Author: Leonix
 * Author URI: https://leonix.ai
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: leonix-ai-widget
 * Domain Path: /languages
 */

// Empêcher l'accès direct
if (!defined('ABSPATH')) {
    exit;
}

// Définir les constantes du plugin
define('LEONIX_WIDGET_VERSION', '1.0.0');
define('LEONIX_WIDGET_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('LEONIX_WIDGET_PLUGIN_URL', plugin_dir_url(__FILE__));
define('LEONIX_WIDGET_PLUGIN_BASENAME', plugin_basename(__FILE__));

/**
 * Classe principale du plugin
 */
class Leonix_AI_Widget {
    
    /**
     * Instance unique du plugin
     */
    private static $instance = null;
    
    /**
     * Obtenir l'instance unique du plugin
     */
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    /**
     * Constructeur
     */
    private function __construct() {
        $this->init_hooks();
    }
    
    /**
     * Initialiser les hooks WordPress
     */
    private function init_hooks() {
        // Hook d'activation
        register_activation_hook(__FILE__, array($this, 'activate'));
        
        // Hook de désactivation
        register_deactivation_hook(__FILE__, array($this, 'deactivate'));
        
        // Initialiser le plugin
        add_action('plugins_loaded', array($this, 'init'));
    }
    
    /**
     * Activation du plugin
     */
    public function activate() {
        // Créer les options par défaut
        add_option('leonix_agent_id', '');
        add_option('leonix_api_url', 'https://app.leonix.ai/api');
        add_option('leonix_widget_enabled', true);
        
        // Flush rewrite rules si nécessaire
        flush_rewrite_rules();
    }
    
    /**
     * Désactivation du plugin
     */
    public function deactivate() {
        // Nettoyer les rewrite rules si nécessaire
        flush_rewrite_rules();
    }
    
    /**
     * Initialiser le plugin
     */
    public function init() {
        // Charger les traductions
        load_plugin_textdomain('leonix-ai-widget', false, dirname(LEONIX_WIDGET_PLUGIN_BASENAME) . '/languages');
        
        // Charger les classes
        require_once LEONIX_WIDGET_PLUGIN_DIR . 'includes/class-leonix-admin.php';
        require_once LEONIX_WIDGET_PLUGIN_DIR . 'includes/class-leonix-public.php';
        
        // Initialiser l'admin
        if (is_admin()) {
            new Leonix_Admin();
        }
        
        // Initialiser le frontend
        new Leonix_Public();
    }
}

/**
 * Fonction d'initialisation du plugin
 */
function leonix_ai_widget_init() {
    return Leonix_AI_Widget::get_instance();
}

// Démarrer le plugin
leonix_ai_widget_init();

